<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns="urn:hl7-org:v3" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:cda="urn:hl7-org:v3"  xmlns:lcg="http://www.lantanagroup.com" exclude-result-prefixes="cda lcg">

	<xsl:output method="xml" version="1.0" encoding="iso-8859-1" indent="yes"/>
	
	<xsl:template match="cda:templateId">
		<xsl:variable name="this-template" select="."/>
		<xsl:variable name="replacement" select="document('templates.xml')/lcg:templates/lcg:template[lcg:replaces[ (lcg:templateId[@root=$this-template/@root][@extension=$this-template/@extension] or lcg:templateId[@root=$this-template/@root and not(@extension) and not($this-template/@extension)] )] ]/lcg:templateId"/> 
		<xsl:choose>
			<xsl:when test="$replacement">
				<templateId root="{$replacement/@root}">
					<xsl:if test="$replacement/@extension">
						<xsl:attribute name="extension"><xsl:value-of select="$replacement/@extension"/></xsl:attribute>
					</xsl:if>
					<xsl:comment>Updated &lt;templateId root="<xsl:value-of select="@root"/>" <xsl:if test="@extension"> extension="<xsl:value-of select="@extension"/>"</xsl:if>/&gt;</xsl:comment>
				</templateId>
			</xsl:when>
			<xsl:otherwise>
				<xsl:copy><xsl:apply-templates select="@*|node()"/></xsl:copy>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template match="@*|node()">
		<xsl:copy>
			<xsl:apply-templates select="@*|node()"/>
		</xsl:copy>
	</xsl:template>	
	
</xsl:stylesheet>